*** COS 2020 07, last update 2023 03  
           
program define dq_fil_exc, rclass  
syntax  , 	[cdir(string) cfile(string) filetype(string) sheetname(string) join(int 0)]	$syntax_datasource_files  $syntax_debugging  
local indent=`indent'+5  
local adoname "dq_fil_exc"  
local text_i "di as text _n "  					  
local reportstop= 0			  
local filestatus=1			  
local filevalidformat=0		  
local tablename="integtable_commandcall"  
local tablerowname="integtablerows_commandcall"  
if strpos(lower("`filetype'"),"study") | strpos(lower("`filetype'"),"result") >0 {  
	local tablename="integtable_studydata"  
	local tablerowname="integtablerows_studydata"  
}          
if strpos(lower("`filetype'"),"meta") >0 {  
	local tablename="integtable_metadata"  
	local tablerowname="integtablerows_metadata"  
}          
if "`cdir'"~="" {  
	mata : st_numscalar("OK", direxists("`cdir'"))  
	if `=OK'==0 {  
	          
		*** DQ_quality_decision: 	DQ_INT_2  
		         
		local reportstop=1					  
		di       
		di as error "Fatal problem: An invalid folder has been specified: `cdir' for the file `cfile' "  
		`text_i' "Data Quality Classification:  Indicator: Data set inaccessible; Implementation form: File location not found for `filetype'"  
		di as text "  "  
		dq_out_add ,  tablename(`tablename') row(`tablerowname') columns(3) colcontent1("$Critical_1") colcontent2("`filetype' `cdir'") colcontent3(Indicator: Data set inaccessible; Implementation form: File location not found - $locationnotfound_critical_1)  indent(`indent')	  
		local filestatus=0					  
	}	        
	if `=OK'==1 {  
	}	        
}          
if "`cfile'"~="" & `filestatus'==1  {  
           
	local cdirfile "`cdir'\`cfile'"	  
	          
	capture confirm file "`cdirfile'"  
	if _rc>0 {  
	          
		*** DQ_quality_decision: 	DQ_INT_1  
		         
		local reportstop=1							  
		di       
		di as error `"Fatal problem: The specified File named `cdirfile' has not been found."'  
		`text_i' "Data Quality Classification:  Indicator: Data set inaccessible; Implementation form: File not found for `filetype'" _n						  
		di as text "  "  
		dq_out_add ,  tablename(`tablename') row(`tablerowname') columns(3) colcontent1("$Critical_1") colcontent2("`filetype' `cdirfile'") colcontent3(Indicator: Data set inaccessible; Implementation form: File not found - $filenotfound_critical_1)  indent(`indent')	  
	}         
	          
	if _rc==0 {  
		`text_i' "File encountered for `filetype' in directory: `cdirfile'"  
		local filestatus=2							  
	}	        
}          
if `filestatus'==0 {  
	`text_i' "No check for the file: ' `cfile' ' was conducted because the specified source location was not found."  
	local filestatus=0								  
}          
if `filestatus'==2 & `join'==0 & `reportstop'==0 {  
	if substr("`cfile'",-3,.)=="dta" {				  
		local filevalidformat=1						  
		capture use "`cdirfile'", clear  
		if _rc==0 local filestatus=3				  
	}         
	          
	if substr("`cfile'",-4,.)=="xlsx" {				  
		local filevalidformat=1						  
		if "`sheetname'"~="" {  
			local sheetrequest "sheet(`sheetname')"  
		}        
		else local sheetrequest ""		  
		capture import excel "`cdirfile'", `sheetrequest' firstrow clear allstring  
		if _rc==0 local filestatus=3				  
	}         
	          
	if `filestatus'==2 &  `filevalidformat'==1 {							  
	          
		*** DQ_quality_decision: 	DQ_INT_3  
		         
		local reportstop=1													  
		di       
		di as error `"Fatal problem: The specified Data set `cfile' is existent but cannot be read:"'  
		di as error "Please check and run Qualityreporter again."					  
		`text_i' "Data Quality Classification:  Indicator: Data set unreadable; Implementation form: File unreadable for `filetype'" _n						  
		di as text "  "  
		         
		dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) colcontent1("$Critical_1") colcontent2("$Studydata `cfile' `sheetrequest'") colcontent3(Indicator: Data set unreadable; Implementation form: File unreadable - $filenotloaded_critical_1)  indent(`indent')	  
	}         
	          
	if `filestatus'==3 {  
		`text_i' "File loaded for:" _column(40) "`filetype' with name `cfile'" _n(2)  
	}	        
}          
if `filestatus'==2 & `join'==1 & `reportstop'==0 {  
	if substr("`cfile'",-3,.)=="dta" {									  
		local filevalidformat=1											  
		dq_fil_app, cdir("`cdir'") cfile(`cfile') filetype(Result data)  indent(`indent')  
		if `r(reportstop)'==0 local filestatus=3						  
	}         
}          
if `filestatus'==2 & `filevalidformat'==0 & `reportstop'==0 {  
	          
	*** DQ_quality_decision: 	DQ_INT_11  
	          
	local reportstop=1												  
	di        
	di as error `"Fatal problem: The specified data file `cfile' does not have a permissible format. Use .dta or .xlsx"'  
	di as text  "Please check and run Qualityreporter again."					  
	`text_i' "Indicator: Data set format error; Implementation form: File not formatted with permissible standard for `filetype'" _n						  
	di as text "  "  
	dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) colcontent1("$Critical_1") colcontent2("$Studydata `cfile'") colcontent3(Indicator: Data set format error; Implementation form: File not formatted with permissible standard - $XXX)  indent(`indent')	  
}          
capture ds(__0000*)  
if `filestatus'==3 & _rc==0  {  
	          
	*** DQ_quality_decision: 	DQ_INT_19  
	          
	local reportstop=1												  
	di        
	di as error `"Fatal problem: Varibales with a temporary format are in the data set. Please remove or rename the variables: `r(varlist)'"'  
	di as error  "Please check and run Qualityreporter again."					  
	`text_i' "Indicator: Data set format error; Implementation form: File not formatted with permissible standard for `filetype'" _n						  
	di as text "  "  
	dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) colcontent1("$Critical_1") colcontent2("`cfile' ") colcontent3($DQ_INT_critical_19: `r(varlist)')  indent(`indent')	  
}          
return local reportstop=`reportstop'  
end        
